//
//  QRCOdeScanViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import UIKit
import AVFoundation

// https://www.hackingwithswift.com/example-code/media/how-to-scan-a-qr-code
class QRCodeScanViewController: UIViewController, AVCaptureMetadataOutputObjectsDelegate {
    
    @IBOutlet var scanImageView: UIImageView!
    
    @IBOutlet var closeButton: UIButton!
    
    public var errorHandler: ((String?) -> Void)?
    
    var captureSession: AVCaptureSession!
    var previewLayer: AVCaptureVideoPreviewLayer!
    
    fileprivate var qrCodeStringPrivate : String = ""

        override func viewDidLoad() {
            super.viewDidLoad()

            //let button = UIButton(frame: CGRect(x: 50, y: 50, width: 100, height: 50))
            //button.backgroundColor = .green
            //button.setTitle("Test Button", for: .normal)
            //self.view.addSubview(button)
            
            self.view.addSubview(closeButton)
            
            scanImageView.translatesAutoresizingMaskIntoConstraints = false
            scanImageView.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true
            scanImageView.centerYAnchor.constraint(equalTo: view.centerYAnchor).isActive = true
            //scanImageView.constrainHeight(constant: self.view.heightAnchor/2)
            scanImageView.widthAnchor.constraint(equalToConstant: self.view.bounds.size.width / 1.5).isActive = true
            scanImageView.heightAnchor.constraint(equalToConstant: self.view.bounds.size.width / 1.5).isActive = true
            
            
            view.backgroundColor = UIColor.black
            captureSession = AVCaptureSession()

            guard let videoCaptureDevice = AVCaptureDevice.default(for: .video) else { return }
            let videoInput: AVCaptureDeviceInput

            do {
                videoInput = try AVCaptureDeviceInput(device: videoCaptureDevice)
            } catch {
                return
            }

            if (captureSession.canAddInput(videoInput)) {
                captureSession.addInput(videoInput)
            } else {
                failed()
                return
            }

            let metadataOutput = AVCaptureMetadataOutput()

            if (captureSession.canAddOutput(metadataOutput)) {
                captureSession.addOutput(metadataOutput)

                metadataOutput.setMetadataObjectsDelegate(self, queue: DispatchQueue.main)
                metadataOutput.metadataObjectTypes = [.qr]
            } else {
                failed()
                return
            }

            previewLayer = AVCaptureVideoPreviewLayer(session: captureSession)
            previewLayer.frame = view.layer.bounds
            previewLayer.videoGravity = .resizeAspectFill
            view.layer.addSublayer(previewLayer)
            
            scanImageView.layer.borderWidth = 5
            scanImageView.layer.borderColor = UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1).cgColor // UIColor.green.cgColor
            self.view.bringSubviewToFront(scanImageView)

            captureSession.startRunning()
            
            self.view.addSubview(closeButton)
        }

        func failed() {
            showErrorMessageQrCodeScanFailedPublic = true

            let tbc = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
            
            self.view.window?.rootViewController = tbc
            self.view.window?.makeKeyAndVisible()
            
            let indexData: [String: Int] = ["index" : 1]
            NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
        
            
            captureSession = nil
        }

        override func viewWillAppear(_ animated: Bool) {
            super.viewWillAppear(animated)

            if (captureSession?.isRunning == false) {
                captureSession.startRunning()
            }
        }

        override func viewWillDisappear(_ animated: Bool) {
            super.viewWillDisappear(animated)

            if (captureSession?.isRunning == true) {
                captureSession.stopRunning()
            }
        }

        func metadataOutput(_ output: AVCaptureMetadataOutput, didOutput metadataObjects: [AVMetadataObject], from connection: AVCaptureConnection) {
            captureSession.stopRunning()

            if let metadataObject = metadataObjects.first {
                guard let readableObject = metadataObject as? AVMetadataMachineReadableCodeObject else { return }
                
                // Extrahiere den Text aus dem QR Code
                guard let qrCodeString = readableObject.stringValue else { return }
                
                AudioServicesPlaySystemSound(SystemSoundID(kSystemSoundID_Vibrate))
                found(code: qrCodeString)
                
                qrCodeStringPrivate = qrCodeString
            }
                dismiss(animated: true)
            
                // Überprüfe, ob der QR Code ein EPC QR Code für Online SEPA Überweisungen ist
                if qrCodeStringPrivate.hasPrefix("BCD") {
                    // Extrahiere BIC, Empfänger, IBAN und Betrag aus dem QR-Code
                    
                    var qrCodeLines = [String]()
                    if qrCodeStringPrivate.contains("\r\n") {
                        qrCodeLines = qrCodeStringPrivate.components(separatedBy: "\r\n") // .newlines // \r\n= , AND break
                    } else if qrCodeStringPrivate.contains("\n"){
                        qrCodeLines = qrCodeStringPrivate.components(separatedBy: "\n")
                    } else {
                        showErrorMessageWrongQRCodePublic = true
                        // back to new transaction screen
                        let tbc = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
                        
                        self.view.window?.rootViewController = tbc
                        self.view.window?.makeKeyAndVisible()
                        
                        let indexData: [String: Int] = ["index" : 1]
                        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
                    }
                    
                    print(qrCodeLines)

                    guard qrCodeLines.count >= 7 else { return }
                    
                    
                    let serviceTagLine = qrCodeLines[0]
                    let versionLine = qrCodeLines[1]
                    let codingLine = qrCodeLines[2]
                    let identificationLine = qrCodeLines[3]
                    var BICLine : String = ""
                    if versionLine == "001" || versionLine=="1" || versionLine == "002" || versionLine == "2" {
                        BICLine = qrCodeLines[4]
                    }
                    let recipientLine = qrCodeLines[5]
                    let IBANLine = qrCodeLines[6]
                    let amountLine = qrCodeLines[7]
                    let DTALine = qrCodeLines[8]
                    let referenceLine = qrCodeLines[9]
                    let purposeLine = qrCodeLines[10]
                    //let userAlertLine = qrCodeLines[11]
                    
                    print("Service Tag: \(serviceTagLine)")
                    print("Version: \(versionLine)")
                    print("Coding: \(codingLine)")
                    print("identification (SCT only = SEPA Credit Transfer): \(identificationLine)")
                    print("BIC: \(BICLine)")
                    print("Recipient: \(recipientLine)")
                    print("IBAN: \(IBANLine)")
                    print("Amount: \(amountLine)")
                    print("DTA: \(DTALine)")
                    print("Reference: \(referenceLine)")
                    print("Purpose: \(purposeLine)")

                    transactionRecipientPublic = recipientLine
                    
                    transactionIBANPublic = IBANLine.separate(every: 4, with: " ")
                    
                    transactionPurposePublic = purposeLine
                    
                    /* ### Transaction Amount Stuff ### */
                    if(amountLine.contains("EUR") && amountLine.contains(".")) {
                        var str = String(amountLine.dropFirst(3))
                        str = str.replacingOccurrences(of: ".", with: ",")
                        transactionAmountPublic = str + " €"
                    } else if(amountLine.contains("EUR")) {
                        let str = String(amountLine.dropFirst(3))
                        transactionAmountPublic = str + ",00 €"
                    } else {
                        showErrorMessageWrongQRCodePublic = true
                        // back to new transaction screen
                        let tbc = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
                        
                        self.view.window?.rootViewController = tbc
                        self.view.window?.makeKeyAndVisible()
                        
                        let indexData: [String: Int] = ["index" : 1]
                        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
                        
                        print("Invalid QR Code -- Missing \"EUR\" and/or \".\"")
                    }
                    
                    
                    var sumGiroAccount : Float = 0.00
                    if UserDefaults.standard.object(forKey: "amountGiroAccount") != nil {
                        let amountGiroAccountAfterTransaction = UserDefaults.standard.float(forKey: "amountGiroAccount")
                        //sumGiroAccount = amountGiroAccountPublic-userTransactionAmountDouble
                        sumGiroAccount = amountGiroAccountAfterTransaction
                        print("amountGiroAccountPublic:")
                        print(amountGiroAccountPublic)
                        print("userTransactionAmountDouble:")
                        print(amountGiroAccountAfterTransaction)
                        
                    } else { // User transaction done
                        sumGiroAccount = amountGiroAccountPublic
                    }
                    
                    let giroLimit : Float = Float(transactionAmountPublic.replacingOccurrences(of: ",", with: ".")) ?? 0.00
                    if(giroLimit >= sumGiroAccount) {
                        print("QR Code scan -- Not enough money.")
                        
                        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionAmountNC") as! UINavigationController
                        
                        nc.modalPresentationStyle = .fullScreen
                        nc.modalTransitionStyle = .coverVertical
                        
                        present(nc, animated: true)
                    } else {

                        
                        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionSummaryNC") as! UIViewController
                        
                        nc.modalPresentationStyle = .fullScreen
                        nc.modalTransitionStyle = .coverVertical
                        
                        present(nc, animated: true)
                        

                    }
                    
                } else {
                    showErrorMessageWrongQRCodePublic = true
                    // back to new transaction screen
                    let tbc = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
                    
                    self.view.window?.rootViewController = tbc
                    self.view.window?.makeKeyAndVisible()
                    
                    let indexData: [String: Int] = ["index" : 1]
                    NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
                }
            
        }

        func found(code: String) {
            print(code)
        }

        override var prefersStatusBarHidden: Bool {
            return true
        }

        override var supportedInterfaceOrientations: UIInterfaceOrientationMask {
            return .portrait
        }
    
    
    
    @IBAction func closeButton(_ sender: Any) {
        cameraAccessInstructionsPublic = true
        
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        tabBarController.modalPresentationStyle = .fullScreen
        tabBarController.modalTransitionStyle = .crossDissolve
        self.present(tabBarController, animated: true)
        
        // https://www.youtube.com/watch?v=43LpNQtUvV4
        let indexData: [String: Int] = ["index" : 1]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
        
    }
    
    
}


extension String {

    func separate(every: Int, with separator: String) -> String {
        return String(stride(from: 0, to: Array(self).count, by: every).map {
            Array(Array(self)[$0..<min($0 + every, Array(self).count)])
        }.joined(separator: separator))
    }
}
